package gov.va.med.mhv.usermgmt.service;

import java.util.List;

import gov.va.med.mhv.common.api.dto.EmergencyContactDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;

public interface EmergencyContactService {
	/**
	 * Save the EmergencyContact
	 *
	 * @param entity EmergencyContact to save
	 * @return EmergencyContact The saved EmergencyContact
	 */
	public void saveEmergencyContact(EmergencyContactDTO emergencyContact, ResponseUtil response);
	
	/**
	 * Delete the EmergencyContact
	 *
	 * @param entity EmergencyContact to delete
	 * @return EmergencyContact The deleted EmergencyContact
	 */
	public void deleteEmergencyContact(EmergencyContactDTO emergencyContact, ResponseUtil response);
	
	/**
	 * Find the EmergencyContact by primary key fields
	 *
	 * @param pk The primary key for the EmergencyContact
	 * @return EmergencyContact The retrieved EmergencyContact
	 */
	public EmergencyContactDTO findByPrimaryKey(EmergencyContactDTO emergencyContact);	
	public ResponseUtil findResponseByPrimaryKey(EmergencyContactDTO emergencyContact);	
	
	//TODO - 
	/**
	 * Get List of Emergency Contacts by id (
	 *
	 * @param pk The primary key for the EmergencyContact
	 * @return EmergencyContact The retrieved EmergencyContact
	 */
	public List<EmergencyContactDTO> findByUserProfileId(Long id);	
	public ResponseUtil findResponseByUserProfileId(Long id);	

	public EmergencyContactDTO getEmergencyContact(Long emergencyContactId);
}